/*
 * Decompiled with CFR 0.152.
 */
package silk;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import silk.SchemeUtils;

public class InputPort
extends SchemeUtils {
    static String EOF = "#!EOF";
    boolean isPushedToken = false;
    boolean isPushedChar = false;
    Object pushedToken;
    int pushedChar = -1;
    Reader in;
    StringBuffer buff = new StringBuffer();

    public InputPort(InputStream inputStream) {
        this.in = new InputStreamReader(inputStream);
    }

    public InputPort(Reader reader) {
        this.in = reader;
    }

    public Object readChar() {
        try {
            if (this.isPushedChar) {
                this.isPushedChar = false;
                if (this.pushedChar == -1) {
                    return EOF;
                }
                return SchemeUtils.chr((char)this.pushedChar);
            }
            int n = this.in.read();
            if (n == -1) {
                return EOF;
            }
            return SchemeUtils.chr((char)n);
        }
        catch (IOException iOException) {
            SchemeUtils.warn("On input, exception: " + iOException);
            return EOF;
        }
    }

    public Object peekChar() {
        int n = this.peekCh();
        if (n == -1) {
            return EOF;
        }
        return SchemeUtils.chr((char)n);
    }

    int pushChar(int n) {
        this.isPushedChar = true;
        this.pushedChar = n;
        return this.pushedChar;
    }

    int popChar() {
        this.isPushedChar = false;
        return this.pushedChar;
    }

    public int peekCh() {
        try {
            if (this.isPushedChar) {
                return this.pushedChar;
            }
            return this.pushChar(this.in.read());
        }
        catch (IOException iOException) {
            SchemeUtils.warn("On input, exception: " + iOException);
            return -1;
        }
    }

    public Object read() {
        try {
            Object object = this.nextToken();
            if (object == "(") {
                return this.readTail(false);
            }
            if (object == ")") {
                SchemeUtils.warn("Extra ) ignored.");
                return this.read();
            }
            if (object == ".") {
                SchemeUtils.warn("Extra . ignored.");
                return this.read();
            }
            if (object == "'") {
                return SchemeUtils.list("quote", this.read());
            }
            if (object == "`") {
                return SchemeUtils.list("quasiquote", this.read());
            }
            if (object == ",") {
                return SchemeUtils.list("unquote", this.read());
            }
            if (object == ",@") {
                return SchemeUtils.list("unquote-splicing", this.read());
            }
            return object;
        }
        catch (IOException iOException) {
            SchemeUtils.warn("On input, exception: " + iOException);
            return EOF;
        }
    }

    public Object close() {
        try {
            this.in.close();
            return SchemeUtils.TRUE;
        }
        catch (IOException iOException) {
            return SchemeUtils.error("IOException: " + iOException);
        }
    }

    public static boolean isEOF(Object object) {
        return object == EOF;
    }

    Object readTail(boolean bl) throws IOException {
        Object object = this.nextToken();
        if (object == EOF) {
            return SchemeUtils.error("EOF during read.");
        }
        if (object == ")") {
            return null;
        }
        if (object == ".") {
            Object object2 = this.read();
            object = this.nextToken();
            if (object != ")") {
                SchemeUtils.warn("Where's the ')'? Got " + object + " after .");
            }
            return object2;
        }
        this.isPushedToken = true;
        this.pushedToken = object;
        return SchemeUtils.cons(this.read(), this.readTail(true));
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object nextToken() throws IOException {
        block33: {
            if (this.isPushedToken) {
                this.isPushedToken = false;
                return this.pushedToken;
            }
            var1_1 = this.isPushedChar ? this.popChar() : this.in.read();
            while (Character.isWhitespace((char)var1_1)) {
                var1_1 = this.in.read();
            }
            cfr_temp_0 = 0;
lbl9:
            // 2 sources

            while (true) {
                switch (cfr_temp_0 == 0 ? var1_1 : cfr_temp_0) {
                    case -1: {
                        return InputPort.EOF;
                    }
                    case 40: {
                        return "(";
                    }
                    case 41: {
                        return ")";
                    }
                    case 39: {
                        return "'";
                    }
                    case 96: {
                        return "`";
                    }
                    case 44: {
                        var1_1 = this.in.read();
                        if (var1_1 == 64) {
                            return ",@";
                        }
                        this.pushChar(var1_1);
                        return ",";
                    }
                    case 34: {
                        this.buff.setLength(0);
                        while (true) {
                            if ((var1_1 = this.in.read()) == 34 || var1_1 == -1) {
                                if (var1_1 != -1) return this.buff.toString().toCharArray();
                                SchemeUtils.warn("EOF inside of a string.");
                                return this.buff.toString().toCharArray();
                            }
                            this.buff.append((char)(var1_1 == 92 ? this.in.read() : var1_1));
                        }
                    }
                    case 35: {
                        var1_1 = this.in.read();
                        switch (var1_1) {
                            case 84: 
                            case 116: {
                                return SchemeUtils.TRUE;
                            }
                            case 70: 
                            case 102: {
                                return SchemeUtils.FALSE;
                            }
                            case 40: {
                                this.pushChar(40);
                                return SchemeUtils.listToVector(this.read());
                            }
                            case 92: {
                                var1_1 = this.in.read();
                                if (var1_1 != 115 && var1_1 != 83 && var1_1 != 110) {
                                    if (var1_1 != 78) return SchemeUtils.chr((char)var1_1);
                                }
                                this.pushChar(var1_1);
                                var2_2 = this.nextToken();
                                if (var2_2 == "space") {
                                    return SchemeUtils.chr(' ');
                                }
                                if (var2_2 == "newline") {
                                    return SchemeUtils.chr('\n');
                                }
                                this.isPushedToken = true;
                                this.pushedToken = var2_2;
                                return SchemeUtils.chr((char)var1_1);
                            }
                            case 100: 
                            case 101: 
                            case 105: {
                                return this.nextToken();
                            }
                            case 98: 
                            case 111: 
                            case 120: {
                                SchemeUtils.warn("#" + (char)var1_1 + " not implemented, ignored.");
                                return this.nextToken();
                            }
                        }
                        SchemeUtils.warn("#" + (char)var1_1 + " not recognized, ignored.");
                        return this.nextToken();
                    }
                    default: {
                        this.buff.setLength(0);
                        var2_3 = var1_1;
                        do {
                            this.buff.append((char)var1_1);
                        } while (!Character.isWhitespace((char)(var1_1 = this.in.read())) && var1_1 != -1 && var1_1 != 40 && var1_1 != 41 && var1_1 != 39 && var1_1 != 59 && var1_1 != 34 && var1_1 != 44 && var1_1 != 96);
                        this.pushChar(var1_1);
                        if (var2_3 != 46 && var2_3 != 43 && var2_3 != 45) {
                            if (var2_3 < 48) return this.buff.toString().toLowerCase().intern();
                            if (var2_3 > 57) return this.buff.toString().toLowerCase().intern();
                        }
                        try {
                            return new Double(this.buff.toString());
                        }
                        catch (NumberFormatException v0) {
                            return this.buff.toString().toLowerCase().intern();
                        }
                    }
lbl89:
                    // 1 sources

                    while (true) {
                        cfr_temp_0 = 59;
                        var1_1 = this.in.read();
                        break;
                    }
                    case 59: 
                }
                break;
            }
            break block33;
            ** while (true)
        }
        if (var1_1 == -1) return this.nextToken();
        if (var1_1 == 10) return this.nextToken();
        ** while (var1_1 != 13)
lbl99:
        // 1 sources

        return this.nextToken();
    }
}

