/*
 * Decompiled with CFR 0.152.
 */
package silk;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import silk.Procedure;
import silk.Scheme;
import silk.SchemeUtils;

public class JavaMethod
extends Procedure {
    Class[] argClasses;
    Method method;
    boolean isStatic;

    public JavaMethod(String string, Object object, Object object2) {
        this.name = String.valueOf(object) + "." + string;
        try {
            this.argClasses = this.classArray(object2);
            this.method = JavaMethod.toClass(object).getMethod(string, this.argClasses);
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            SchemeUtils.error("Bad class, can't get method " + this.name);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SchemeUtils.error("Can't get method " + this.name);
            return;
        }
    }

    public Object apply(Scheme scheme, Object object) {
        try {
            if (this.isStatic) {
                return this.method.invoke(null, this.toArray(object));
            }
            return this.method.invoke(SchemeUtils.first(object), this.toArray(SchemeUtils.rest(object)));
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NullPointerException nullPointerException) {}
        return SchemeUtils.error("Bad Java Method application:" + this + SchemeUtils.stringify(object) + ", ");
    }

    public static Class toClass(Object object) throws ClassNotFoundException {
        if (object instanceof Class) {
            return (Class)object;
        }
        if ((object = SchemeUtils.stringify(object, false)).equals("void")) {
            return Void.TYPE;
        }
        if (object.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (object.equals("char")) {
            return Character.TYPE;
        }
        if (object.equals("byte")) {
            return Byte.TYPE;
        }
        if (object.equals("short")) {
            return Short.TYPE;
        }
        if (object.equals("int")) {
            return Integer.TYPE;
        }
        if (object.equals("long")) {
            return Long.TYPE;
        }
        if (object.equals("float")) {
            return Float.TYPE;
        }
        if (object.equals("double")) {
            return Double.TYPE;
        }
        return Class.forName((String)object);
    }

    public Object[] toArray(Object object) {
        int n = SchemeUtils.length(object);
        int n2 = n - this.argClasses.length;
        if (n2 != 0) {
            SchemeUtils.error(String.valueOf(Math.abs(n2)) + " too " + (n2 > 0 ? "many" : "few") + " args to " + this.name);
        }
        Object[] objectArray = new Object[n];
        int n3 = 0;
        while (n3 < n && n3 < this.argClasses.length) {
            objectArray[n3] = this.argClasses[n3] == Integer.TYPE ? new Integer((int)SchemeUtils.num(SchemeUtils.first(object))) : SchemeUtils.first(object);
            object = SchemeUtils.rest(object);
            ++n3;
        }
        return objectArray;
    }

    public Class[] classArray(Object object) throws ClassNotFoundException {
        int n = SchemeUtils.length(object);
        Class[] classArray = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray[n2] = JavaMethod.toClass(SchemeUtils.first(object));
            object = SchemeUtils.rest(object);
            ++n2;
        }
        return classArray;
    }
}

